<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Project;
use App\Models\Review;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;

class ProjectReviews extends Component
{
    use WithPagination;

    public Project $project;
    
    // Form fields
    public $rating = 5;
    public $title = '';
    public $content = '';

    protected $rules = [
        'rating' => 'required|integer|min:1|max:5',
        'title' => 'nullable|string|max:255',
        'content' => 'required|string|min:10',
    ];

    public function mount(Project $project)
    {
        $this->project = $project;
    }

    public function submitReview()
    {
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        $this->validate();

        $this->project->reviews()->create([
            'user_id' => Auth::id(),
            'rating' => $this->rating,
            'title' => $this->title,
            'content' => $this->content,
        ]);

        // Recalculate project stats
        $avg = $this->project->reviews()->avg('rating');
        $count = $this->project->reviews()->count();
        
        $this->project->update([
            'star_rating' => $avg,
            'review_count' => $count
        ]);

        $this->reset(['rating', 'title', 'content']);
        session()->flash('message', 'Review submitted successfully!');
    }

    public function render()
    {
        return view('livewire.project-reviews', [
            'reviews' => $this->project->reviews()->latest()->with('user')->paginate(5),
        ]);
    }
}
