<div class="container mx-auto px-4 py-8">
    {{-- Header Section --}}
    <div class="bg-white rounded-lg shadow-lg p-6 mb-8">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center">
            <div>
                <div class="flex items-center gap-2 mb-2">
                    <span class="px-2 py-1 text-xs font-semibold text-blue-800 bg-blue-100 rounded-full">
                        {{ $project->category->name }}
                    </span>
                    @if($project->online_status === 'online')
                        <span class="px-2 py-1 text-xs font-semibold text-green-800 bg-green-100 rounded-full">Online</span>
                    @else
                        <span class="px-2 py-1 text-xs font-semibold text-red-800 bg-red-100 rounded-full">Offline</span>
                    @endif
                </div>
                <h1 class="text-4xl font-bold text-gray-900 mb-2">{{ $project->name }}</h1>
                <a href="{{ $project->website_url }}" target="_blank" class="text-blue-600 hover:text-blue-800 flex items-center gap-1">
                    {{ $project->website_url }} 
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path></svg>
                </a>
            </div>
            <div class="mt-4 md:mt-0 text-right">
                <div class="flex items-center justify-end gap-1 mb-1">
                    <span class="text-2xl font-bold text-gray-900">{{ $project->star_rating }}</span>
                    <span class="text-yellow-400 text-2xl">★</span>
                </div>
                <p class="text-gray-500 text-sm">{{ $project->review_count }} Reviews</p>
                <div class="mt-2">
                     <span class="font-semibold text-gray-700">Trust Score:</span> 
                     <span class="font-bold {{ $project->trust_score >= 80 ? 'text-green-600' : ($project->trust_score >= 50 ? 'text-yellow-600' : 'text-red-600') }}">
                        {{ $project->trust_score }}/100
                     </span>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        {{-- Main Content --}}
        <div class="lg:col-span-2 space-y-8">
            {{-- Description --}}
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-2xl font-bold mb-4">About {{ $project->name }}</h2>
                <div class="prose max-w-none text-gray-700">
                    {{ $project->description }}
                </div>
            </div>

            {{-- Features & Attributes --}}
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-2xl font-bold mb-4">Features & Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <p><span class="font-semibold">Privacy Level:</span> {{ $project->privacy_level ?? 'N/A' }}</p>
                        <p><span class="font-semibold">AML Risk:</span> {{ $project->aml_risk_level ?? 'N/A' }}</p>
                        <p><span class="font-semibold">Regulatory Status:</span> {{ $project->regulatory_status ?? 'Unknown' }}</p>
                        <p><span class="font-semibold">Jurisdiction:</span> {{ $project->jurisdiction ?? 'Global' }}</p>
                    </div>
                    <div class="space-y-2">
                        <p><span class="font-semibold">Registration Required:</span> {{ $project->registration_required ? 'Yes' : 'No' }}</p>
                        <p><span class="font-semibold">No Log Policy:</span> {{ $project->no_log_policy ? 'Yes' : 'No' }}</p>
                        <p><span class="font-semibold">Source Code:</span> {{ $project->source_code_availability ? 'Open Source' : 'Closed Source' }}</p>
                        <p><span class="font-semibold">Own Liquidity:</span> {{ $project->own_liquidity ? 'Yes' : 'No' }}</p>
                    </div>
                </div>
                
                @if($project->features)
                <div class="mt-6">
                    <h3 class="font-bold mb-2">Key Features</h3>
                    <div class="flex flex-wrap gap-2">
                        @foreach($project->features as $feature)
                            <span class="px-3 py-1 bg-gray-100 rounded-full text-sm text-gray-700">{{ $feature }}</span>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>

            {{-- Category Specifics --}}
            @if($project->category->slug === 'mixers' || $project->category->slug === 'exchanges')
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-2xl font-bold mb-4">Fees & Limits</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    @if($project->min_service_fee)
                        <div class="p-4 bg-gray-50 rounded">
                            <span class="block text-gray-500 text-sm">Min Service Fee</span>
                            <span class="font-bold text-lg">{{ $project->min_service_fee }}%</span>
                        </div>
                    @endif
                    @if($project->fixed_fee)
                         <div class="p-4 bg-gray-50 rounded">
                            <span class="block text-gray-500 text-sm">Fixed Fee</span>
                            <span class="font-bold text-lg">{{ $project->fixed_fee }}</span>
                        </div>
                    @endif
                     @if($project->min_time_delay)
                         <div class="p-4 bg-gray-50 rounded">
                            <span class="block text-gray-500 text-sm">Min Time Delay</span>
                            <span class="font-bold text-lg">{{ $project->min_time_delay }} mins</span>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            {{-- Reviews Section --}}
            <livewire:project-reviews :project="$project" />
        </div>

        {{-- Sidebar --}}
        <div class="lg:col-span-1 space-y-8">
            {{-- Status Card --}}
            <div class="bg-white rounded-lg shadow p-6 border-t-4 {{ $project->list_status === 'verified' ? 'border-green-500' : 'border-gray-300' }}">
                <h3 class="font-bold text-gray-900 mb-4">Project Status</h3>
                <div class="flex items-center gap-2 mb-4">
                    @if($project->list_status === 'verified')
                        <svg class="w-6 h-6 text-green-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>
                        <span class="font-bold text-green-700 uppercase">Verified Listing</span>
                    @elseif($project->list_status === 'scam')
                         <span class="font-bold text-red-700 uppercase">⚠️ SCAM WARNING</span>
                    @else
                        <span class="font-bold text-gray-700 uppercase">{{ $project->list_status }}</span>
                    @endif
                </div>
                
                @if($project->ownership_verified)
                    <div class="flex items-center gap-2 text-sm text-blue-700 bg-blue-50 p-2 rounded">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg>
                        Ownership Verified
                    </div>
                @endif
            </div>

            {{-- Supported Cryptos --}}
            @if($project->supported_cryptos)
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-bold text-gray-900 mb-4">Supported Cryptos</h3>
                <div class="flex flex-wrap gap-2">
                    @foreach($project->supported_cryptos as $crypto)
                        <span class="px-2 py-1 bg-gray-100 text-xs font-mono rounded">{{ $crypto }}</span>
                    @endforeach
                </div>
            </div>
            @endif

            {{-- Official Channels --}}
             @if($project->discussion_channels)
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="font-bold text-gray-900 mb-4">Community & Social</h3>
                <ul class="space-y-2">
                    @foreach($project->discussion_channels as $channel)
                        <li><a href="#" class="text-blue-600 hover:underline text-sm">{{ $channel }}</a></li>
                    @endforeach
                </ul>
            </div>
            @endif
        </div>
    </div>
</div>