<div class="mt-8">
    <div class="bg-white rounded-lg shadow p-6 mb-8">
        <h3 class="text-2xl font-bold mb-6">User Reviews</h3>

        @if(session()->has('message'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4">
                {{ session('message') }}
            </div>
        @endif

        @auth
            <form wire:submit.prevent="submitReview" class="mb-8 p-4 bg-gray-50 rounded-lg border border-gray-200">
                <h4 class="font-bold mb-4">Write a Review</h4>
                
                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Rating</label>
                    <div class="flex items-center gap-4">
                        @foreach(range(1, 5) as $i)
                            <label class="cursor-pointer">
                                <input type="radio" wire:model="rating" value="{{ $i }}" class="hidden peer">
                                <span class="text-2xl peer-checked:text-yellow-400 text-gray-300 hover:text-yellow-300">★</span>
                            </label>
                        @endforeach
                    </div>
                    @error('rating') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title (Optional)</label>
                    <input wire:model="title" type="text" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    @error('title') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Review</label>
                    <textarea wire:model="content" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline h-32"></textarea>
                    @error('content') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                </div>

                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded focus:outline-none focus:shadow-outline">
                    Submit Review
                </button>
            </form>
        @else
            <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-8">
                <p class="text-blue-700">Please <a href="/login" class="font-bold underline">login</a> via the forum to leave a review.</p>
            </div>
        @endauth

        <div class="space-y-6">
            @foreach($reviews as $review)
                <div class="border-b border-gray-200 pb-6 last:border-0">
                    <div class="flex justify-between items-start mb-2">
                        <div class="flex items-center gap-2">
                            <span class="font-bold text-gray-900">{{ $review->user->name ?? 'Anonymous' }}</span>
                            <span class="text-gray-400 text-sm">{{ $review->created_at->diffForHumans() }}</span>
                        </div>
                        <div class="flex text-yellow-400">
                            @for($i = 0; $i < 5; $i++)
                                <span>{{ $i < $review->rating ? '★' : '☆' }}</span>
                            @endfor
                        </div>
                    </div>
                    @if($review->title)
                        <h5 class="font-bold text-gray-800 mb-1">{{ $review->title }}</h5>
                    @endif
                    <p class="text-gray-600">{{ $review->content }}</p>
                </div>
            @endforeach

            {{ $reviews->links() }}
        </div>
    </div>
</div>