<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\ProjectList;
use App\Livewire\ProjectDetail;
use App\Livewire\SubmitProject;
use App\Livewire\AdminDashboard;
use App\Http\Middleware\AdminMiddleware;

Route::get('/', ProjectList::class)->name('home');
Route::get('/projects/{project:slug}', ProjectDetail::class)->name('projects.show');

Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/submit', SubmitProject::class)->name('projects.submit');
});

// Auth Routes for redirect purposes
Route::get('/login', function () {
    return redirect(rtrim((string) config('smf.url', 'http://localhost/wlc/forum'), '/') . '/index.php?action=login');
})->name('login');

Route::get('/register', function () {
    return redirect(rtrim((string) config('smf.url', 'http://localhost/wlc/forum'), '/') . '/index.php?action=register');
})->name('register');

Route::middleware([AdminMiddleware::class])->group(function () {
    Route::get('/admin', AdminDashboard::class)->name('admin.dashboard');
});
