<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <title><?php echo e($title ?? 'WeLiveCrypto Directory'); ?></title>
        
        <!-- Tailwind CSS via CDN for Quick Dev -->
        <script src="https://cdn.tailwindcss.com"></script>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    </head>
    <body class="bg-gray-50 text-gray-900 font-sans antialiased">
        <nav class="bg-white shadow-sm border-b border-gray-200">
            <div class="container mx-auto px-4">
                <div class="flex justify-between h-16">
                    <div class="flex">
                        <div class="shrink-0 flex items-center">
                            <a href="/" class="font-bold text-xl text-blue-600">WeLiveCrypto</a>
                        </div>
                        <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                            <a href="/" class="inline-flex items-center px-1 pt-1 border-b-2 border-blue-500 text-sm font-medium leading-5 text-gray-900 focus:outline-none focus:border-blue-700 transition duration-150 ease-in-out">
                                Directory
                            </a>
                            <a href="#" class="inline-flex items-center px-1 pt-1 border-b-2 border-transparent text-sm font-medium leading-5 text-gray-500 hover:text-gray-700 hover:border-gray-300 focus:outline-none focus:text-gray-700 focus:border-gray-300 transition duration-150 ease-in-out">
                                Forum
                            </a>
                        </div>
                    </div>
                    <div class="flex items-center space-x-4">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('projects.submit')); ?>" class="text-sm font-medium text-blue-600 hover:text-blue-800">
                                + Submit Project
                            </a>
                            
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(Auth::user()->isModerator()): ?>
                                <a href="<?php echo e(route('admin.dashboard')); ?>" class="text-sm font-medium text-red-600 hover:text-red-800">
                                    Admin Dashboard
                                </a>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <div class="text-sm text-gray-500">
                                Hello, <?php echo e(Auth::user()->name); ?>

                            </div>
                        <?php else: ?>
                            <a href="/login" class="text-sm text-gray-600 hover:text-gray-900">Login / Register</a>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>

        <main>
            <?php echo e($slot); ?>

        </main>

        <footer class="bg-gray-800 text-white py-8 mt-12">
            <div class="container mx-auto px-4 text-center">
                <p>&copy; <?php echo e(date('Y')); ?> WeLiveCrypto. All rights reserved.</p>
            </div>
        </footer>
    </body>
</html><?php /**PATH C:\Users\Hp\Desktop\MY Work\WeLiveCrypto\directory-app\resources\views/components/layouts/app.blade.php ENDPATH**/ ?>